/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.events;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.charred.CharredBlock;
import com.ordana.immersive_weathering.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.blocks.mossable.Mossable;
import com.ordana.immersive_weathering.blocks.rustable.Rustable;
import com.ordana.immersive_weathering.blocks.sandy.Sandy;
import com.ordana.immersive_weathering.blocks.snowy.Snowy;
import com.ordana.immersive_weathering.blocks.soil.MulchBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.BlockGrowthHandler;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import com.ordana.immersive_weathering.integration.QuarkPlugin;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModSoundEvents;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.reg.ModWaxables;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.misc.EventCalled;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1743;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5945;
import net.minecraft.class_5955;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static class_1269 onBlockCLicked(class_1799 stack, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        class_1792 i = stack.method_7909();
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        for (InteractionEvent event : EVENTS) {
            class_1269 result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    private static class_1269 rustSponging(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        Rustable rustable;
        Optional<class_2680> rusted;
        class_2248 class_22482;
        if (item == class_1802.field_8554 && CommonConfigs.SPONGE_RUSTING.get().booleanValue() && (class_22482 = state.method_26204()) instanceof Rustable && (rusted = (rustable = (Rustable)class_22482).method_31639(state)).isPresent()) {
            level.method_8396(player, pos, class_3417.field_14756, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.SCRAPE_RUST.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_11202, (class_6017)class_6019.method_35017((int)3, (int)5));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (CommonConfigs.SPONGE_RUST_DRYING.get().booleanValue()) {
                    class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1802.field_8535.method_7854());
                    player.method_6122(hand, itemStack2);
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                level.method_8501(pos, rusted.get());
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static class_1269 rustScraping(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_3222 serverPlayer;
        class_2248 class_22482;
        if (!CommonConfigs.AXE_SCRAPING.get().booleanValue()) return class_1269.field_5811;
        if (item instanceof class_1743 && (class_22482 = state.method_26204()) instanceof Rustable) {
            Rustable rustable = (Rustable)class_22482;
            if (!state.method_26164(ModTags.WAXED_BLOCKS)) {
                Rustable.RustLevel rustLevel = (Rustable.RustLevel)rustable.method_33622();
                if (!rustLevel.canScrape()) {
                    level.method_8396(player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                    level.method_8396(player, pos, class_3417.field_15239, class_3419.field_15245, 1.0f, 1.0f);
                    class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.SCRAPE_RUST.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
                    class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_11251, (class_6017)class_6019.method_35017((int)3, (int)5));
                    if (!(player instanceof class_3222)) return class_1269.method_29236((boolean)level.field_9236);
                    class_3222 serverPlayer2 = (class_3222)player;
                    stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                    player.method_7259(class_3468.field_15372.method_14956((Object)item));
                    class_174.field_24478.method_23889(serverPlayer2, pos, stack);
                    return class_1269.method_29236((boolean)level.field_9236);
                }
                if (rustLevel == Rustable.RustLevel.UNAFFECTED) return class_1269.field_5811;
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.SCRAPE_RUST.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
                level.method_8396(player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                if (!(player instanceof class_3222)) return class_1269.method_29236((boolean)level.field_9236);
                class_3222 serverPlayer3 = (class_3222)player;
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                level.method_8501(pos, rustable.getPrevious(state).get());
                class_174.field_24478.method_23889(serverPlayer3, pos, stack);
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        if (item != ModItems.STEEL_WOOL.get()) return class_1269.field_5811;
        class_2248 serverPlayer3 = state.method_26204();
        if (serverPlayer3 instanceof Rustable) {
            Rustable.RustLevel rustLevel;
            Rustable rustable = (Rustable)serverPlayer3;
            if (!state.method_26164(ModTags.WAXED_BLOCKS) && (rustLevel = (Rustable.RustLevel)rustable.method_33622()) != Rustable.RustLevel.UNAFFECTED) {
                level.method_8396(player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.SCRAPE_RUST.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
                if (!(player instanceof class_3222)) return class_1269.method_29236((boolean)level.field_9236);
                class_3222 serverPlayer4 = (class_3222)player;
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                class_174.field_24478.method_23889(serverPlayer4, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                level.method_8501(pos, rustable.getPrevious(state).get());
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        if (state.method_26164(ModTags.WAXED_BLOCKS)) {
            level.method_8396(player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_29643, (class_6017)class_6019.method_35017((int)3, (int)5));
            if (!(player instanceof class_3222)) return class_1269.method_29236((boolean)level.field_9236);
            serverPlayer = (class_3222)player;
            stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
            class_174.field_24478.method_23889(serverPlayer, pos, stack);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            level.method_8501(pos, Objects.requireNonNull(ModWaxables.getUnWaxed(state).orElse(null)));
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (!state.method_26164(ModTags.COPPER)) return class_1269.field_5811;
        level.method_8396(player, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
        class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_29645, (class_6017)class_6019.method_35017((int)3, (int)5));
        if (!(player instanceof class_3222)) return class_1269.method_29236((boolean)level.field_9236);
        serverPlayer = (class_3222)player;
        stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
        class_174.field_24478.method_23889(serverPlayer, pos, stack);
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        class_5955.method_34735((class_2680)state).ifPresent(o -> level.method_8501(pos, o));
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private static class_1269 grassFlinting(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item == class_1802.field_8145 && CommonConfigs.GRASS_FLINTING.get().booleanValue()) {
            if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10402) || state.method_27852(class_2246.field_10520) || state.method_27852(ModBlocks.HUMUS.get()) || state.method_27852(ModBlocks.FLUVISOL.get())) {
                level.method_8396(player, pos, class_3417.field_15037, class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11217, state), (class_6017)class_6019.method_35017((int)3, (int)5));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    level.method_8501(pos, class_2246.field_10566.method_9564());
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
            if (state.method_27852(class_2246.field_10566)) {
                level.method_8396(player, pos, class_3417.field_14609, class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11217, state), (class_6017)class_6019.method_35017((int)3, (int)5));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    level.method_8501(pos, class_2246.field_10253.method_9564());
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 spawnAsh(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item instanceof class_1821 && CommonConfigs.ASH_ITEM_SPAWN.get().booleanValue()) {
            if (state.method_26204() instanceof class_3922 && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() && (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue())) {
                class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)class_2350.field_11036, (class_1799)new class_1799((class_1935)ModBlocks.ASH_LAYER_BLOCK.get()));
            }
            return class_1269.field_5811;
        }
        if (item == class_1802.field_8279) {
            if (state.method_26204() instanceof MulchBlock) {
                level.method_8396(player, pos, ModSoundEvents.YUMMY.get(), class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5811;
        }
        if (item == class_1802.field_8463) {
            if (state.method_26204() instanceof MulchBlock) {
                level.method_8396(player, pos, ModSoundEvents.YUMMY.get(), class_3419.field_15245, 1.0f, 2.0f);
            }
            return class_1269.field_5811;
        }
        if (item == class_1802.field_8367) {
            if (state.method_26204() instanceof MulchBlock) {
                level.method_8396(player, pos, ModSoundEvents.YUMMY.get(), class_3419.field_15245, 2.0f, 0.3f);
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static class_1269 slimePistons(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item == class_1802.field_8777 && CommonConfigs.PISTON_SLIMING.get().booleanValue() && state.method_27852(class_2246.field_10560) && !((Boolean)state.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
            if (level.field_9236) {
                level.method_8396(player, pos, class_3417.field_15095, class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_11246, (class_6017)class_6019.method_35017((int)3, (int)5));
            } else {
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_8501(pos, class_2246.field_10615.method_34725(state));
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (item == class_1802.field_8868 && CommonConfigs.PISTON_SLIMING.get().booleanValue() && state.method_27852(class_2246.field_10615) && !((Boolean)state.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
            if (level.field_9236) {
                level.method_8396(player, pos, class_3417.field_15095, class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_11246, (class_6017)class_6019.method_35017((int)3, (int)5));
            } else {
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_33596((class_1297)player, class_5712.field_28730, pos);
                level.method_8501(pos, class_2246.field_10560.method_34725(state));
                if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)class_1802.field_8777.method_7854());
                }
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 shearShearing(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item instanceof class_1820) {
            class_2680 newState = null;
            if (CommonConfigs.AZALEA_SHEARING.get().booleanValue() && (newState = (class_2680)WeatheringHelper.getAzaleaSheared(state).orElse(null)) != null) {
                if (level.field_9236) {
                    class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.AZALEA_FLOWER.get()), (class_6017)class_6019.method_35017((int)4, (int)6));
                } else {
                    class_174.field_24478.method_23889((class_3222)player, pos, stack);
                    if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                        class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)new class_1799((class_1935)ModItems.AZALEA_FLOWERS.get()));
                    }
                }
            }
            if (newState == null && CommonConfigs.MOSS_SHEARING.get().booleanValue()) {
                newState = Mossable.getUnaffectedMossBlock(state);
                if (newState != state) {
                    if (IntegrationHandler.quark) {
                        newState = QuarkPlugin.fixVerticalSlab(newState, state);
                    }
                    if (level.field_9236) {
                        class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)((class_2394)ModParticles.MOSS.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
                    } else {
                        class_174.field_24478.method_23889((class_3222)player, pos, stack);
                        if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                            class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)new class_1799((class_1935)ModItems.MOSS_CLUMP.get()));
                        }
                    }
                } else {
                    newState = null;
                }
            }
            if (newState != null) {
                level.method_8396(player, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
                level.method_8501(pos, newState);
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                    level.method_33596((class_1297)player, class_5712.field_28730, pos);
                    player.method_7259(class_3468.field_15372.method_14956((Object)item));
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 burnMoss(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_2680 newBlock;
        if (item instanceof class_1786 && CommonConfigs.MOSS_BURNING.get().booleanValue() && (newBlock = Mossable.getUnaffectedMossBlock(state)) != state) {
            newBlock = Weatherable.setStable(newBlock);
            if (level.field_9236) {
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_11240, (class_6017)class_6019.method_35017((int)3, (int)5));
                level.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_8501(pos, newBlock);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 pickaxeCracking(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item instanceof class_1810 && CommonConfigs.PICKAXE_CRACKING.get().booleanValue()) {
            if (!player.method_21823() && CommonConfigs.PICKAXE_CRACKING_SHIFT.get().booleanValue()) {
                return class_1269.field_5811;
            }
            class_2680 newBlock = Crackable.getCrackedBlock(state);
            if (newBlock != state) {
                if (IntegrationHandler.quark) {
                    newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
                }
                if (level.field_9236) {
                    class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11217, state), (class_6017)class_6019.method_35017((int)3, (int)5));
                    level.method_8396(player, pos, newBlock.method_26231().method_10596(), class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    class_174.field_24478.method_23889((class_3222)player, pos, stack);
                    class_2248 class_22482 = state.method_26204();
                    if (class_22482 instanceof Crackable) {
                        Crackable crackable = (Crackable)class_22482;
                        stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                        player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                        level.method_8501(pos, newBlock);
                        if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                            class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)crackable.getRepairItem(state).method_7854());
                        }
                    }
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 brickRepair(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_2680 newBlock;
        Crackable crackable;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof Crackable && (crackable = (Crackable)class_22482).getRepairItem(state) == item && state.method_26164(ModTags.CRACKED) && (newBlock = Crackable.getUncrackedCrackBlock(state)) != null) {
            newBlock = Weatherable.setStable(newBlock);
            if (IntegrationHandler.quark) {
                newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
            }
            if (level.field_9236) {
                level.method_8396(player, pos, newBlock.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
            } else {
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_8501(pos, newBlock);
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 axeStripping(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_1792 bark;
        if (item instanceof class_1743 && CommonConfigs.AXE_STRIPPING.get().booleanValue() && (bark = WeatheringHelper.getBarkToStrip(state)) != null) {
            if (level.field_9236) {
                level.method_8396(player, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                class_2394 barkParticle = WeatheringHelper.getBarkParticle(state);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)barkParticle, (class_6017)class_6019.method_35017((int)3, (int)5));
            } else {
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)bark.method_7854());
                }
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 barkRepairing(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        Pair fixedLog;
        if (stack.method_31573(ModTags.BARK) && (fixedLog = (Pair)WeatheringHelper.getBarkForStrippedLog(state).orElse(null)) != null && stack.method_7909() == fixedLog.getFirst()) {
            class_2680 newBlock = ((class_2248)fixedLog.getSecond()).method_34725(state);
            if (IntegrationHandler.quark) {
                newBlock = QuarkPlugin.fixVerticalSlab(newBlock, state);
            }
            if (level.field_9236) {
                level.method_8396(player, pos, newBlock.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
            } else {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                class_174.field_24478.method_23889((class_3222)player, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_8501(pos, newBlock);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 blockSanding(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        Optional<class_2680> sandy = Sandy.getSandy(state);
        if (stack.method_31574(ModBlocks.SAND_LAYER_BLOCK.get().method_8389()) && (sandy.isPresent() || state.method_26204() instanceof Sandy && (Integer)state.method_11654((class_2769)ModBlockProperties.SANDINESS) == 0)) {
            level.method_8396(player, pos, class_3417.field_15144, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
            stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                if (sandy.isPresent()) {
                    level.method_8501(pos, sandy.get());
                } else {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(1)));
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 blockSnowing(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        Optional<class_2680> snowy = Snowy.getSnowy(state);
        if (stack.method_31574(class_1802.field_8543) && snowy.isPresent()) {
            level.method_8396(player, pos, class_3417.field_14945, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10491.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
            stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                level.method_8501(pos, snowy.get());
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    @EventCalled
    public static void onLightningHit(ILightningStruckBlockEvent event) {
        class_2338 blockPos = event.getPos();
        class_1936 level = event.getLevel();
        class_2680 blockState = level.method_8320(blockPos);
        BlockGrowthHandler.tickBlock(TickSource.LIGHTNING, blockState, (class_3218)level, blockPos);
    }

    @EventCalled
    public static boolean onFireConsume(IFireConsumeBlockEvent event) {
        class_1936 level = event.getLevel();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2338 pos = event.getPos();
            class_2680 state = event.getState();
            double charChance = CommonConfigs.FIRE_CHARS_WOOD_CHANCE.get();
            double ashChance = CommonConfigs.ASH_SPAWNS_CHANCE.get();
            if (charChance != 0.0 || ashChance != 0.0) {
                class_2680 charred;
                class_2680 newState = null;
                class_2680 class_26802 = charred = charChance != 0.0 ? WeatheringHelper.getCharredState(state) : null;
                if (charred != null && (double)serverLevel.field_9229.method_43057() < charChance) {
                    newState = (class_2680)charred.method_11657((class_2769)CharredBlock.SMOLDERING, (Comparable)Boolean.valueOf(serverLevel.field_9229.method_43056()));
                }
                if (charred == null && (double)serverLevel.field_9229.method_43057() < ashChance) {
                    if (PlatformHelper.isModLoaded((String)"supplementaries")) {
                        return false;
                    }
                    newState = ModBlocks.ASH_LAYER_BLOCK.get().method_9564();
                }
                if (newState != null) {
                    serverLevel.method_14199((class_2394)ModParticles.SOOT.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
                    return serverLevel.method_8652(pos, newState, 3);
                }
            }
        }
        return false;
    }

    static {
        EVENTS.add(ModEvents::slimePistons);
        EVENTS.add(ModEvents::pickaxeCracking);
        EVENTS.add(ModEvents::brickRepair);
        EVENTS.add(ModEvents::burnMoss);
        EVENTS.add(ModEvents::shearShearing);
        EVENTS.add(ModEvents::spawnAsh);
        EVENTS.add(ModEvents::grassFlinting);
        EVENTS.add(ModEvents::axeStripping);
        EVENTS.add(ModEvents::barkRepairing);
        EVENTS.add(ModEvents::rustScraping);
        EVENTS.add(ModEvents::rustSponging);
        EVENTS.add(ModEvents::blockSanding);
        EVENTS.add(ModEvents::blockSnowing);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public class_1269 run(class_1792 var1, class_1799 var2, class_2338 var3, class_2680 var4, class_1657 var5, class_1937 var6, class_1268 var7, class_3965 var8);
    }
}

